% optitest_2.m

% needs and uses obejective_2.m, objejective_2a.m, and restriction_2a.m
% corresponds to problem 4 of zaliczenie, 20030221

% myoptions = optimset('MaxFunEvals',10000);

[xopt,vopt] = fminunc('objective_2',  [0 0])
[x0,v0]     = fmincon('objective_2a', [0 0], [],[],[],[],[],[],'restriction_2a') %,myoptions)

% the empty brackets represent the (non-existent) linear inequality restrictions (matrix, vector)
% the linear equality restriction (matrix, vector), box constraints (lower, upper bounds)
% the nonlinear restictions come both in one function: first output of restriction_2a.m
% is the left-hand side of g(x) <= 0, the second (empty, []), output component is reserved
% equality constrints - here absent

x1 = 0.5:0.1:3;
x2 = -5:0.1:0.5;

[x1,x2] = meshgrid(x1,x2);

f = (2*x1-1).^2+(x2-1).^2/9+2;
g = (x1-3).^2+(x2+2).^2-4;

warning off
figure(1) 
contour(x1,x2,f,25);         hold on
contour(x1,x2,g,[0 0]); 
plot([xopt(1)], [xopt(2)],'rx', ...
     [x0(1)], [x0(2)],'b+','markersize', 24);  hold off

figure(2)
surfl(x1,x2,f+10*max(0*g,g).^2)               % try remowing .^2 ! (in objective_2.m as well!)
set(gca,'zlim',[2.5,25],'view',[45,75])





