function eqnarray
disp('demo: eqnarray')
x=[0;0];
disp(['initial guess: ' num2str(x') ' and its image: ' num2str(f(x)')])

disp('matlab solver')
xstar=fsolve(@f,x,optimset('display','off'));
disp(['sol: ' num2str(xstar',20) ' defect: ' num2str(f(xstar)',20)])

disp('with harder error bounds:')
xstarstar=fsolve(@f,xstar,optimset('display','off','tolfun',1e-14,'tolx',1e-14));
disp(['sol: ' num2str(xstarstar',20) ' defect: ' num2str(f(xstarstar)',20)])

function y=f(x)
y=x;
y(1)=4*x(1)-x(2)+x(1)^2+x(2)^2-4;
y(2)=exp(x(1))-8*x(2);