using NLsolve, Plots;

function f!(y,x)
    y[1]=x[1]^2+x[2]^2-9;
    y[2]=x[2]-tan(x[1]);
    end;

x0=ones(2);

sol=nlsolve(f!,x0)

xstar=sol.zero

contour(-4:0.1:4,-4:0.1:4,(x,y)->x^2+y^2-9,levels=[0],
     color=:red,linewidth=3,colorbar=false)

plot!(tan,-1.3,1.3,color=:blue,linewidth=3,
   size=(600,600),xlims=(-4,4),ylims=(-4,4))

scatter!([xstar[1]],[xstar[2]],color=:green,markersize=8,legend=false)

scatter!([-xstar[1]],[-xstar[2]],color=:green,markersize=8,legend=false)
xlabel!("x"); ylabel!("y"); 
png("circleandtangens25")
