using Optim, Plots, LaTeXStrings;
pyplot();

kapdat=
[  2.0  1.1
   5.0  14.0
  10.0 100.0
  12.0 150.0
  13.5 180.0
  15.0 205.0
  16.5 210.0
  18.0 208.0
  20.0 120.0
  30.0  15.0
  40.0   5.0
  50.0   2.9
  80.0   1.0 ];

plot(kapdat[:,1],kapdat[:,2],legend=false,linewidth=3,
   xlabel=latexstring("\\theta"),ylabel=latexstring("\\kappa"))

plot(log.(kapdat[:,1]),log.(kapdat[:,2]),linewidth=3,color=:cyan,legend=false)

plot(log.(kapdat[:,1]),log.(log.(kapdat[:,2])),color=:pink,linewidth=3,legend=false)

x=log.(kapdat[1:12,1]);
y=log.(log.(kapdat[1:12,2]));
A=[ones(length(x)) x x.^2]

abc=A\y

z=A*abc

xstrng=latexstring("\\theta");
ystrng=latexstring("\\kappa");
scatter(x,y,color=:green,markershape=:diamond,markersize=8,label="measured")
plot!(x->abc[1]+abc[2]*x+abc[3]*x^2,x[1],x[end],color=:red,linewidth=3,label="fitted",
    legend=:bottomright,xlabel="double log "*xstrng, ylabel=ystrng)

kappa(theta;a=abc[1],b=abc[2],c=abc[3])=exp(exp(a+b*log(theta)+c*log(theta)^2))

plot(kappa,0,80,color=:red,label="theoretical")
scatter!(kapdat[:,1],kapdat[:,2],color=:green,label="measured")
xlabel!(xstrng); ylabel!(ystrng)

thetas=kapdat[:,1];
kappas=kapdat[:,2];

F(abc)=sum((map(theta->kappa(theta;a=abc[1],b=abc[2],c=abc[3]),thetas)-kappas).^2)

F(abc)

sol=optimize(F, abc, BFGS())

abcopt=sol.minimizer

F(abcopt)

F(abc)-F(abcopt)

(F(abc)-F(abcopt))/F(abcopt)

kappaopt(theta)=kappa(theta;a=abcopt[1],b=abcopt[2],c=abcopt[3])

plot!(kappaopt,0,80,color=:blue,linewidth=3,label="optimal fit")

xlabel!(xstrng)
ylabel!(ystrng)

png("kapanddat25.png")
