using NLsolve, Plots;

f(x)=sin(x)-x/2

function f!(y,x)
    y[1]=f(x[1]);
end
x0=[2.0];
sol=nlsolve(f!,x0)

sol.zero

xstar=sol.zero[1];
f(xstar)

g(x)=[f.(x[1])]    # g ist eine Funktion des Vektors x, die für jeden Komponente
                   # das skalare f aufruft - auch wenn es nur eine Komponente gibt ...

slg=nlsolve(g,x0)

g(slg.zero)

plot(sin,0,2.5,legend=false)
plot!(x->x/2,0,2.5,xlabel="x",ylabel="y",title="sin(x)=x/2")
scatter!([xstar],[sin(xstar)],markersize=8)

png("sinandlin25.png")
