using DifferentialEquations,Plots;

f(y,p,t)=p*y;

deqprbl=ODEProblem(f,3.0,(0.0,12.0),-0.33)

solu=solve(deqprbl)

plot(t->solu(t),0,12,legend=false,title="Lösung des AWP")

scatter!(solu.t,solu.u,xlabel="Zeit t",ylabel="Menge y(t)")

function f!(yp,y,p,t) 
    g=p[1]; l=p[2];
   yp[1]=y[2];
   yp[2]=-g*sin(y[1])/l;
   return;
end;
y0=[0.0,6.26]; tspan=(0.0,12.0); p=(9.81,1.0);    
pendprob=ODEProblem(f!,y0,tspan,p)

pendsol=solve(pendprob,reltol=1.0e-4)

plot(t->pendsol(t)[1],0,12,label="Winkel",
   xlabel="Zeit t")
plot!(t->pendsol(t)[2],0,12,label="Spin",
   ylabel="Winkel und Spin")

plot(t->pendsol(t)[1],t->pendsol(t)[2],0,12,leg=false,
    title="Phasenportrtät",xlabel="Winkel",ylabel="Spin")
